package io.k8s.api.networking.v1


/** IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource. */
final case class IngressClassParametersReference(
  name : String,
  scope : Option[String] = None,
  apiGroup : Option[String] = None,
  namespace : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : IngressClassParametersReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : IngressClassParametersReference = copy(name = f(name))

  /** Returns a new data with scope set to new value */
  def withScope(value: String) : IngressClassParametersReference = copy(scope = Some(value))
  /** if scope has a value, transforms to the result of function*/
  def mapScope(f: String => String) : IngressClassParametersReference = copy(scope = scope.map(f))

  /** Returns a new data with apiGroup set to new value */
  def withApiGroup(value: String) : IngressClassParametersReference = copy(apiGroup = Some(value))
  /** if apiGroup has a value, transforms to the result of function*/
  def mapApiGroup(f: String => String) : IngressClassParametersReference = copy(apiGroup = apiGroup.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : IngressClassParametersReference = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : IngressClassParametersReference = copy(namespace = namespace.map(f))
}

