package io.k8s.api.networking.v1

import dev.hnaderi.k8s._

/** Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc. */
final case class Ingress(
  status : Option[io.k8s.api.networking.v1.IngressStatus] = None,
  spec : Option[io.k8s.api.networking.v1.IngressSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "Ingress", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.networking.v1.IngressStatus) : Ingress = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.networking.v1.IngressStatus => io.k8s.api.networking.v1.IngressStatus) : Ingress = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.networking.v1.IngressSpec) : Ingress = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.networking.v1.IngressSpec => io.k8s.api.networking.v1.IngressSpec) : Ingress = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Ingress = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Ingress = copy(metadata = metadata.map(f))
}

