package io.k8s.api.flowcontrol.v1beta2


/** PriorityLevelConfigurationCondition defines the condition of priority level. */
final case class PriorityLevelConfigurationCondition(
  reason : Option[String] = None,
  status : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : Option[String] = None
) {

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : PriorityLevelConfigurationCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : PriorityLevelConfigurationCondition = copy(reason = reason.map(f))

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : PriorityLevelConfigurationCondition = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: String => String) : PriorityLevelConfigurationCondition = copy(status = status.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PriorityLevelConfigurationCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : PriorityLevelConfigurationCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : PriorityLevelConfigurationCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : PriorityLevelConfigurationCondition = copy(message = message.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : PriorityLevelConfigurationCondition = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : PriorityLevelConfigurationCondition = copy(`type` = `type`.map(f))
}

