package io.k8s.api.flowcontrol.v1beta2


/** LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
  - How are requests for this priority level limited?
  - What should be done with requests that exceed the limit? */
final case class LimitedPriorityLevelConfiguration(
  assuredConcurrencyShares : Option[Int] = None,
  limitResponse : Option[io.k8s.api.flowcontrol.v1beta2.LimitResponse] = None
) {

  /** Returns a new data with assuredConcurrencyShares set to new value */
  def withAssuredConcurrencyShares(value: Int) : LimitedPriorityLevelConfiguration = copy(assuredConcurrencyShares = Some(value))
  /** if assuredConcurrencyShares has a value, transforms to the result of function*/
  def mapAssuredConcurrencyShares(f: Int => Int) : LimitedPriorityLevelConfiguration = copy(assuredConcurrencyShares = assuredConcurrencyShares.map(f))

  /** Returns a new data with limitResponse set to new value */
  def withLimitResponse(value: io.k8s.api.flowcontrol.v1beta2.LimitResponse) : LimitedPriorityLevelConfiguration = copy(limitResponse = Some(value))
  /** if limitResponse has a value, transforms to the result of function*/
  def mapLimitResponse(f: io.k8s.api.flowcontrol.v1beta2.LimitResponse => io.k8s.api.flowcontrol.v1beta2.LimitResponse) : LimitedPriorityLevelConfiguration = copy(limitResponse = limitResponse.map(f))
}

