package io.k8s.api.flowcontrol.v1beta1


/** Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account. */
final case class Subject(
  group : Option[io.k8s.api.flowcontrol.v1beta1.GroupSubject] = None,
  serviceAccount : Option[io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject] = None,
  user : Option[io.k8s.api.flowcontrol.v1beta1.UserSubject] = None
) {

  /** Returns a new data with group set to new value */
  def withGroup(value: io.k8s.api.flowcontrol.v1beta1.GroupSubject) : Subject = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: io.k8s.api.flowcontrol.v1beta1.GroupSubject => io.k8s.api.flowcontrol.v1beta1.GroupSubject) : Subject = copy(group = group.map(f))

  /** Returns a new data with serviceAccount set to new value */
  def withServiceAccount(value: io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject) : Subject = copy(serviceAccount = Some(value))
  /** if serviceAccount has a value, transforms to the result of function*/
  def mapServiceAccount(f: io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject => io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject) : Subject = copy(serviceAccount = serviceAccount.map(f))

  /** Returns a new data with user set to new value */
  def withUser(value: io.k8s.api.flowcontrol.v1beta1.UserSubject) : Subject = copy(user = Some(value))
  /** if user has a value, transforms to the result of function*/
  def mapUser(f: io.k8s.api.flowcontrol.v1beta1.UserSubject => io.k8s.api.flowcontrol.v1beta1.UserSubject) : Subject = copy(user = user.map(f))
}

