package io.k8s.api.flowcontrol.v1beta1


/** ServiceAccountSubject holds detailed information for service-account-kind subject. */
final case class ServiceAccountSubject(
  name : String,
  namespace : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServiceAccountSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ServiceAccountSubject = copy(name = f(name))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ServiceAccountSubject = copy(namespace = value)
  /** transforms namespace to result of function */
  def mapNamespace(f: String => String) : ServiceAccountSubject = copy(namespace = f(namespace))
}

