package io.k8s.api.flowcontrol.v1beta1


/** FlowSchemaCondition describes conditions for a FlowSchema. */
final case class FlowSchemaCondition(
  reason : Option[String] = None,
  status : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : Option[String] = None
) {

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : FlowSchemaCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : FlowSchemaCondition = copy(reason = reason.map(f))

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : FlowSchemaCondition = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: String => String) : FlowSchemaCondition = copy(status = status.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : FlowSchemaCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : FlowSchemaCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : FlowSchemaCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : FlowSchemaCondition = copy(message = message.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : FlowSchemaCondition = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : FlowSchemaCondition = copy(`type` = `type`.map(f))
}

