package io.k8s.api.discovery.v1


/** ForZone provides information about which zones should consume this endpoint. */
final case class ForZone(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ForZone = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ForZone = copy(name = f(name))
}

