package io.k8s.api.discovery.v1


/** EndpointHints provides hints describing how an endpoint should be consumed. */
final case class EndpointHints(
  forZones : Option[Seq[io.k8s.api.discovery.v1.ForZone]] = None
) {

  /** Returns a new data with forZones set to new value */
  def withForZones(value: Seq[io.k8s.api.discovery.v1.ForZone]) : EndpointHints = copy(forZones = Some(value))
  /** Appends new values to forZones */
  def addForZones(newValues: io.k8s.api.discovery.v1.ForZone*) : EndpointHints = copy(forZones = Some(forZones.fold(newValues)(_ ++ newValues)))
  /** if forZones has a value, transforms to the result of function*/
  def mapForZones(f: Seq[io.k8s.api.discovery.v1.ForZone] => Seq[io.k8s.api.discovery.v1.ForZone]) : EndpointHints = copy(forZones = forZones.map(f))
}

