package io.k8s.api.core.v1


/** The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s) */
final case class WeightedPodAffinityTerm(
  podAffinityTerm : io.k8s.api.core.v1.PodAffinityTerm,
  weight : Int
) {

  /** Returns a new data with podAffinityTerm set to new value */
  def withPodAffinityTerm(value: io.k8s.api.core.v1.PodAffinityTerm) : WeightedPodAffinityTerm = copy(podAffinityTerm = value)
  /** transforms podAffinityTerm to result of function */
  def mapPodAffinityTerm(f: io.k8s.api.core.v1.PodAffinityTerm => io.k8s.api.core.v1.PodAffinityTerm) : WeightedPodAffinityTerm = copy(podAffinityTerm = f(podAffinityTerm))

  /** Returns a new data with weight set to new value */
  def withWeight(value: Int) : WeightedPodAffinityTerm = copy(weight = value)
  /** transforms weight to result of function */
  def mapWeight(f: Int => Int) : WeightedPodAffinityTerm = copy(weight = f(weight))
}

