package io.k8s.api.core.v1


/** SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace */
final case class SecretReference(
  name : Option[String] = None,
  namespace : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : SecretReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : SecretReference = copy(name = name.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : SecretReference = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : SecretReference = copy(namespace = namespace.map(f))
}

