package io.k8s.api.core.v1


/** Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic. */
final case class Probe(
  timeoutSeconds : Option[Int] = None,
  grpc : Option[io.k8s.api.core.v1.GRPCAction] = None,
  tcpSocket : Option[io.k8s.api.core.v1.TCPSocketAction] = None,
  initialDelaySeconds : Option[Int] = None,
  failureThreshold : Option[Int] = None,
  httpGet : Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  terminationGracePeriodSeconds : Option[Int] = None,
  exec : Option[io.k8s.api.core.v1.ExecAction] = None,
  periodSeconds : Option[Int] = None,
  successThreshold : Option[Int] = None
) {

  /** Returns a new data with timeoutSeconds set to new value */
  def withTimeoutSeconds(value: Int) : Probe = copy(timeoutSeconds = Some(value))
  /** if timeoutSeconds has a value, transforms to the result of function*/
  def mapTimeoutSeconds(f: Int => Int) : Probe = copy(timeoutSeconds = timeoutSeconds.map(f))

  /** Returns a new data with grpc set to new value */
  def withGrpc(value: io.k8s.api.core.v1.GRPCAction) : Probe = copy(grpc = Some(value))
  /** if grpc has a value, transforms to the result of function*/
  def mapGrpc(f: io.k8s.api.core.v1.GRPCAction => io.k8s.api.core.v1.GRPCAction) : Probe = copy(grpc = grpc.map(f))

  /** Returns a new data with tcpSocket set to new value */
  def withTcpSocket(value: io.k8s.api.core.v1.TCPSocketAction) : Probe = copy(tcpSocket = Some(value))
  /** if tcpSocket has a value, transforms to the result of function*/
  def mapTcpSocket(f: io.k8s.api.core.v1.TCPSocketAction => io.k8s.api.core.v1.TCPSocketAction) : Probe = copy(tcpSocket = tcpSocket.map(f))

  /** Returns a new data with initialDelaySeconds set to new value */
  def withInitialDelaySeconds(value: Int) : Probe = copy(initialDelaySeconds = Some(value))
  /** if initialDelaySeconds has a value, transforms to the result of function*/
  def mapInitialDelaySeconds(f: Int => Int) : Probe = copy(initialDelaySeconds = initialDelaySeconds.map(f))

  /** Returns a new data with failureThreshold set to new value */
  def withFailureThreshold(value: Int) : Probe = copy(failureThreshold = Some(value))
  /** if failureThreshold has a value, transforms to the result of function*/
  def mapFailureThreshold(f: Int => Int) : Probe = copy(failureThreshold = failureThreshold.map(f))

  /** Returns a new data with httpGet set to new value */
  def withHttpGet(value: io.k8s.api.core.v1.HTTPGetAction) : Probe = copy(httpGet = Some(value))
  /** if httpGet has a value, transforms to the result of function*/
  def mapHttpGet(f: io.k8s.api.core.v1.HTTPGetAction => io.k8s.api.core.v1.HTTPGetAction) : Probe = copy(httpGet = httpGet.map(f))

  /** Returns a new data with terminationGracePeriodSeconds set to new value */
  def withTerminationGracePeriodSeconds(value: Int) : Probe = copy(terminationGracePeriodSeconds = Some(value))
  /** if terminationGracePeriodSeconds has a value, transforms to the result of function*/
  def mapTerminationGracePeriodSeconds(f: Int => Int) : Probe = copy(terminationGracePeriodSeconds = terminationGracePeriodSeconds.map(f))

  /** Returns a new data with exec set to new value */
  def withExec(value: io.k8s.api.core.v1.ExecAction) : Probe = copy(exec = Some(value))
  /** if exec has a value, transforms to the result of function*/
  def mapExec(f: io.k8s.api.core.v1.ExecAction => io.k8s.api.core.v1.ExecAction) : Probe = copy(exec = exec.map(f))

  /** Returns a new data with periodSeconds set to new value */
  def withPeriodSeconds(value: Int) : Probe = copy(periodSeconds = Some(value))
  /** if periodSeconds has a value, transforms to the result of function*/
  def mapPeriodSeconds(f: Int => Int) : Probe = copy(periodSeconds = periodSeconds.map(f))

  /** Returns a new data with successThreshold set to new value */
  def withSuccessThreshold(value: Int) : Probe = copy(successThreshold = Some(value))
  /** if successThreshold has a value, transforms to the result of function*/
  def mapSuccessThreshold(f: Int => Int) : Probe = copy(successThreshold = successThreshold.map(f))
}

