package io.k8s.api.core.v1



final case class PortStatus(
  port : Int,
  protocol : String,
  error : Option[String] = None
) {

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : PortStatus = copy(port = value)
  /** transforms port to result of function */
  def mapPort(f: Int => Int) : PortStatus = copy(port = f(port))

  /** Returns a new data with protocol set to new value */
  def withProtocol(value: String) : PortStatus = copy(protocol = value)
  /** transforms protocol to result of function */
  def mapProtocol(f: String => String) : PortStatus = copy(protocol = f(protocol))

  /** Returns a new data with error set to new value */
  def withError(value: String) : PortStatus = copy(error = Some(value))
  /** if error has a value, transforms to the result of function*/
  def mapError(f: String => String) : PortStatus = copy(error = error.map(f))
}

