package io.k8s.api.core.v1


/** PodReadinessGate contains the reference to a pod condition */
final case class PodReadinessGate(
  conditionType : String
) {

  /** Returns a new data with conditionType set to new value */
  def withConditionType(value: String) : PodReadinessGate = copy(conditionType = value)
  /** transforms conditionType to result of function */
  def mapConditionType(f: String => String) : PodReadinessGate = copy(conditionType = f(conditionType))
}

