package io.k8s.api.core.v1


/** PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system). */
final case class PersistentVolumeClaimVolumeSource(
  claimName : String,
  readOnly : Option[Boolean] = None
) {

  /** Returns a new data with claimName set to new value */
  def withClaimName(value: String) : PersistentVolumeClaimVolumeSource = copy(claimName = value)
  /** transforms claimName to result of function */
  def mapClaimName(f: String => String) : PersistentVolumeClaimVolumeSource = copy(claimName = f(claimName))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : PersistentVolumeClaimVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : PersistentVolumeClaimVolumeSource = copy(readOnly = readOnly.map(f))
}

