package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PersistentVolumeClaim is a user's request for and claim to a persistent volume */
final case class PersistentVolumeClaim(
  status : Option[io.k8s.api.core.v1.PersistentVolumeClaimStatus] = None,
  spec : Option[io.k8s.api.core.v1.PersistentVolumeClaimSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PersistentVolumeClaim", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.PersistentVolumeClaimStatus) : PersistentVolumeClaim = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.PersistentVolumeClaimStatus => io.k8s.api.core.v1.PersistentVolumeClaimStatus) : PersistentVolumeClaim = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaim = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.PersistentVolumeClaimSpec => io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaim = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaim = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaim = copy(metadata = metadata.map(f))
}

