package io.k8s.api.core.v1


/** Local represents directly-attached storage with node affinity (Beta feature) */
final case class LocalVolumeSource(
  path : String,
  fsType : Option[String] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : LocalVolumeSource = copy(path = value)
  /** transforms path to result of function */
  def mapPath(f: String => String) : LocalVolumeSource = copy(path = f(path))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : LocalVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : LocalVolumeSource = copy(fsType = fsType.map(f))
}

