package io.k8s.api.core.v1



final case class GRPCAction(
  port : Int,
  service : Option[String] = None
) {

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : GRPCAction = copy(port = value)
  /** transforms port to result of function */
  def mapPort(f: Int => Int) : GRPCAction = copy(port = f(port))

  /** Returns a new data with service set to new value */
  def withService(value: String) : GRPCAction = copy(service = Some(value))
  /** if service has a value, transforms to the result of function*/
  def mapService(f: String => String) : GRPCAction = copy(service = service.map(f))
}

