package io.k8s.api.core.v1


/** Represents an ephemeral volume that is handled by a normal storage driver. */
final case class EphemeralVolumeSource(
  volumeClaimTemplate : Option[io.k8s.api.core.v1.PersistentVolumeClaimTemplate] = None
) {

  /** Returns a new data with volumeClaimTemplate set to new value */
  def withVolumeClaimTemplate(value: io.k8s.api.core.v1.PersistentVolumeClaimTemplate) : EphemeralVolumeSource = copy(volumeClaimTemplate = Some(value))
  /** if volumeClaimTemplate has a value, transforms to the result of function*/
  def mapVolumeClaimTemplate(f: io.k8s.api.core.v1.PersistentVolumeClaimTemplate => io.k8s.api.core.v1.PersistentVolumeClaimTemplate) : EphemeralVolumeSource = copy(volumeClaimTemplate = volumeClaimTemplate.map(f))
}

