package io.k8s.api.core.v1


/** ContainerPort represents a network port in a single container. */
final case class ContainerPort(
  containerPort : Int,
  name : Option[String] = None,
  hostPort : Option[Int] = None,
  hostIP : Option[String] = None,
  protocol : Option[String] = None
) {

  /** Returns a new data with containerPort set to new value */
  def withContainerPort(value: Int) : ContainerPort = copy(containerPort = value)
  /** transforms containerPort to result of function */
  def mapContainerPort(f: Int => Int) : ContainerPort = copy(containerPort = f(containerPort))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ContainerPort = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ContainerPort = copy(name = name.map(f))

  /** Returns a new data with hostPort set to new value */
  def withHostPort(value: Int) : ContainerPort = copy(hostPort = Some(value))
  /** if hostPort has a value, transforms to the result of function*/
  def mapHostPort(f: Int => Int) : ContainerPort = copy(hostPort = hostPort.map(f))

  /** Returns a new data with hostIP set to new value */
  def withHostIP(value: String) : ContainerPort = copy(hostIP = Some(value))
  /** if hostIP has a value, transforms to the result of function*/
  def mapHostIP(f: String => String) : ContainerPort = copy(hostIP = hostIP.map(f))

  /** Returns a new data with protocol set to new value */
  def withProtocol(value: String) : ContainerPort = copy(protocol = Some(value))
  /** if protocol has a value, transforms to the result of function*/
  def mapProtocol(f: String => String) : ContainerPort = copy(protocol = protocol.map(f))
}

