package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ConfigMap holds configuration data for pods to consume. */
final case class ConfigMap(
  data : Option[Map[String, String]] = None,
  immutable : Option[Boolean] = None,
  binaryData : Option[Map[String, String]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ConfigMap", "v1")


  /** Returns a new data with data set to new value */
  def withData(value: Map[String, String]) : ConfigMap = copy(data = Some(value))
  /** Adds new values to data */
  def addData(newValues: (String, String)*) : ConfigMap = copy(data = Some(data.fold(newValues.toMap)(_ ++ newValues)))
  /** if data has a value, transforms to the result of function*/
  def mapData(f: Map[String, String] => Map[String, String]) : ConfigMap = copy(data = data.map(f))

  /** Returns a new data with immutable set to new value */
  def withImmutable(value: Boolean) : ConfigMap = copy(immutable = Some(value))
  /** if immutable has a value, transforms to the result of function*/
  def mapImmutable(f: Boolean => Boolean) : ConfigMap = copy(immutable = immutable.map(f))

  /** Returns a new data with binaryData set to new value */
  def withBinaryData(value: Map[String, String]) : ConfigMap = copy(binaryData = Some(value))
  /** Adds new values to binaryData */
  def addBinaryData(newValues: (String, String)*) : ConfigMap = copy(binaryData = Some(binaryData.fold(newValues.toMap)(_ ++ newValues)))
  /** if binaryData has a value, transforms to the result of function*/
  def mapBinaryData(f: Map[String, String] => Map[String, String]) : ConfigMap = copy(binaryData = binaryData.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ConfigMap = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ConfigMap = copy(metadata = metadata.map(f))
}

