package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ComponentStatus (and ComponentStatusList) holds the cluster validation info. Deprecated: This API is deprecated in v1.19+ */
final case class ComponentStatus(
  conditions : Option[Seq[io.k8s.api.core.v1.ComponentCondition]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ComponentStatus", "v1")


  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.core.v1.ComponentCondition]) : ComponentStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.core.v1.ComponentCondition*) : ComponentStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.core.v1.ComponentCondition] => Seq[io.k8s.api.core.v1.ComponentCondition]) : ComponentStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ComponentStatus = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ComponentStatus = copy(metadata = metadata.map(f))
}

