package io.k8s.api.core.v1


/** ClientIPConfig represents the configurations of Client IP based session affinity. */
final case class ClientIPConfig(
  timeoutSeconds : Option[Int] = None
) {

  /** Returns a new data with timeoutSeconds set to new value */
  def withTimeoutSeconds(value: Int) : ClientIPConfig = copy(timeoutSeconds = Some(value))
  /** if timeoutSeconds has a value, transforms to the result of function*/
  def mapTimeoutSeconds(f: Int => Int) : ClientIPConfig = copy(timeoutSeconds = timeoutSeconds.map(f))
}

