package io.k8s.api.coordination.v1


/** LeaseSpec is a specification of a Lease. */
final case class LeaseSpec(
  leaseTransitions : Option[Int] = None,
  holderIdentity : Option[String] = None,
  leaseDurationSeconds : Option[Int] = None,
  renewTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  acquireTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None
) {

  /** Returns a new data with leaseTransitions set to new value */
  def withLeaseTransitions(value: Int) : LeaseSpec = copy(leaseTransitions = Some(value))
  /** if leaseTransitions has a value, transforms to the result of function*/
  def mapLeaseTransitions(f: Int => Int) : LeaseSpec = copy(leaseTransitions = leaseTransitions.map(f))

  /** Returns a new data with holderIdentity set to new value */
  def withHolderIdentity(value: String) : LeaseSpec = copy(holderIdentity = Some(value))
  /** if holderIdentity has a value, transforms to the result of function*/
  def mapHolderIdentity(f: String => String) : LeaseSpec = copy(holderIdentity = holderIdentity.map(f))

  /** Returns a new data with leaseDurationSeconds set to new value */
  def withLeaseDurationSeconds(value: Int) : LeaseSpec = copy(leaseDurationSeconds = Some(value))
  /** if leaseDurationSeconds has a value, transforms to the result of function*/
  def mapLeaseDurationSeconds(f: Int => Int) : LeaseSpec = copy(leaseDurationSeconds = leaseDurationSeconds.map(f))

  /** Returns a new data with renewTime set to new value */
  def withRenewTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(renewTime = Some(value))
  /** if renewTime has a value, transforms to the result of function*/
  def mapRenewTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(renewTime = renewTime.map(f))

  /** Returns a new data with acquireTime set to new value */
  def withAcquireTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(acquireTime = Some(value))
  /** if acquireTime has a value, transforms to the result of function*/
  def mapAcquireTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : LeaseSpec = copy(acquireTime = acquireTime.map(f))
}

