package io.k8s.api.batch.v1


/** JobStatus represents the current state of a Job. */
final case class JobStatus(
  conditions : Option[Seq[io.k8s.api.batch.v1.JobCondition]] = None,
  uncountedTerminatedPods : Option[io.k8s.api.batch.v1.UncountedTerminatedPods] = None,
  completedIndexes : Option[String] = None,
  startTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  ready : Option[Int] = None,
  failed : Option[Int] = None,
  succeeded : Option[Int] = None,
  completionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  active : Option[Int] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.batch.v1.JobCondition]) : JobStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.batch.v1.JobCondition*) : JobStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.batch.v1.JobCondition] => Seq[io.k8s.api.batch.v1.JobCondition]) : JobStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with uncountedTerminatedPods set to new value */
  def withUncountedTerminatedPods(value: io.k8s.api.batch.v1.UncountedTerminatedPods) : JobStatus = copy(uncountedTerminatedPods = Some(value))
  /** if uncountedTerminatedPods has a value, transforms to the result of function*/
  def mapUncountedTerminatedPods(f: io.k8s.api.batch.v1.UncountedTerminatedPods => io.k8s.api.batch.v1.UncountedTerminatedPods) : JobStatus = copy(uncountedTerminatedPods = uncountedTerminatedPods.map(f))

  /** Returns a new data with completedIndexes set to new value */
  def withCompletedIndexes(value: String) : JobStatus = copy(completedIndexes = Some(value))
  /** if completedIndexes has a value, transforms to the result of function*/
  def mapCompletedIndexes(f: String => String) : JobStatus = copy(completedIndexes = completedIndexes.map(f))

  /** Returns a new data with startTime set to new value */
  def withStartTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : JobStatus = copy(startTime = Some(value))
  /** if startTime has a value, transforms to the result of function*/
  def mapStartTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : JobStatus = copy(startTime = startTime.map(f))

  /** Returns a new data with ready set to new value */
  def withReady(value: Int) : JobStatus = copy(ready = Some(value))
  /** if ready has a value, transforms to the result of function*/
  def mapReady(f: Int => Int) : JobStatus = copy(ready = ready.map(f))

  /** Returns a new data with failed set to new value */
  def withFailed(value: Int) : JobStatus = copy(failed = Some(value))
  /** if failed has a value, transforms to the result of function*/
  def mapFailed(f: Int => Int) : JobStatus = copy(failed = failed.map(f))

  /** Returns a new data with succeeded set to new value */
  def withSucceeded(value: Int) : JobStatus = copy(succeeded = Some(value))
  /** if succeeded has a value, transforms to the result of function*/
  def mapSucceeded(f: Int => Int) : JobStatus = copy(succeeded = succeeded.map(f))

  /** Returns a new data with completionTime set to new value */
  def withCompletionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : JobStatus = copy(completionTime = Some(value))
  /** if completionTime has a value, transforms to the result of function*/
  def mapCompletionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : JobStatus = copy(completionTime = completionTime.map(f))

  /** Returns a new data with active set to new value */
  def withActive(value: Int) : JobStatus = copy(active = Some(value))
  /** if active has a value, transforms to the result of function*/
  def mapActive(f: Int => Int) : JobStatus = copy(active = active.map(f))
}

