package io.k8s.api.autoscaling.v2beta2


/** PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second). */
final case class PodsMetricStatus(
  current : io.k8s.api.autoscaling.v2beta2.MetricValueStatus,
  metric : io.k8s.api.autoscaling.v2beta2.MetricIdentifier
) {

  /** Returns a new data with current set to new value */
  def withCurrent(value: io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : PodsMetricStatus = copy(current = value)
  /** transforms current to result of function */
  def mapCurrent(f: io.k8s.api.autoscaling.v2beta2.MetricValueStatus => io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : PodsMetricStatus = copy(current = f(current))

  /** Returns a new data with metric set to new value */
  def withMetric(value: io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : PodsMetricStatus = copy(metric = value)
  /** transforms metric to result of function */
  def mapMetric(f: io.k8s.api.autoscaling.v2beta2.MetricIdentifier => io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : PodsMetricStatus = copy(metric = f(metric))
}

