package io.k8s.api.autoscaling.v2beta2


/** MetricIdentifier defines the name and optionally selector for a metric */
final case class MetricIdentifier(
  name : String,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : MetricIdentifier = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : MetricIdentifier = copy(name = f(name))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MetricIdentifier = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MetricIdentifier = copy(selector = selector.map(f))
}

