package io.k8s.api.autoscaling.v2beta2


/** ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object. */
final case class ExternalMetricStatus(
  current : io.k8s.api.autoscaling.v2beta2.MetricValueStatus,
  metric : io.k8s.api.autoscaling.v2beta2.MetricIdentifier
) {

  /** Returns a new data with current set to new value */
  def withCurrent(value: io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : ExternalMetricStatus = copy(current = value)
  /** transforms current to result of function */
  def mapCurrent(f: io.k8s.api.autoscaling.v2beta2.MetricValueStatus => io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : ExternalMetricStatus = copy(current = f(current))

  /** Returns a new data with metric set to new value */
  def withMetric(value: io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : ExternalMetricStatus = copy(metric = value)
  /** transforms metric to result of function */
  def mapMetric(f: io.k8s.api.autoscaling.v2beta2.MetricIdentifier => io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : ExternalMetricStatus = copy(metric = f(metric))
}

