package io.k8s.api.autoscaling.v2


/** ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set. */
final case class ResourceMetricSource(
  name : String,
  target : io.k8s.api.autoscaling.v2.MetricTarget
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ResourceMetricSource = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ResourceMetricSource = copy(name = f(name))

  /** Returns a new data with target set to new value */
  def withTarget(value: io.k8s.api.autoscaling.v2.MetricTarget) : ResourceMetricSource = copy(target = value)
  /** transforms target to result of function */
  def mapTarget(f: io.k8s.api.autoscaling.v2.MetricTarget => io.k8s.api.autoscaling.v2.MetricTarget) : ResourceMetricSource = copy(target = f(target))
}

