package io.k8s.api.authorization.v1


/** SelfSubjectRulesReviewSpec defines the specification for SelfSubjectRulesReview. */
final case class SelfSubjectRulesReviewSpec(
  namespace : Option[String] = None
) {

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : SelfSubjectRulesReviewSpec = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : SelfSubjectRulesReviewSpec = copy(namespace = namespace.map(f))
}

