package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** DaemonSet represents the configuration of a daemon set. */
final case class DaemonSet(
  status : Option[io.k8s.api.apps.v1.DaemonSetStatus] = None,
  spec : Option[io.k8s.api.apps.v1.DaemonSetSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "DaemonSet", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.apps.v1.DaemonSetStatus) : DaemonSet = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.apps.v1.DaemonSetStatus => io.k8s.api.apps.v1.DaemonSetStatus) : DaemonSet = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.apps.v1.DaemonSetSpec) : DaemonSet = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.apps.v1.DaemonSetSpec => io.k8s.api.apps.v1.DaemonSetSpec) : DaemonSet = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : DaemonSet = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : DaemonSet = copy(metadata = metadata.map(f))
}

