package io.k8s.api.apiserverinternal.v1alpha1

import dev.hnaderi.k8s._

/** Storage version of a specific resource. */
final case class StorageVersion(
  status : io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus,
  spec : io.k8s.api.apiserverinternal.v1alpha1.StorageVersionSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("internal.apiserver.k8s.io", "StorageVersion", "v1alpha1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus) : StorageVersion = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus => io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus) : StorageVersion = copy(status = f(status))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionSpec) : StorageVersion = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionSpec => io.k8s.api.apiserverinternal.v1alpha1.StorageVersionSpec) : StorageVersion = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : StorageVersion = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : StorageVersion = copy(metadata = metadata.map(f))
}

