package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1


/** ServiceReference holds a reference to Service.legacy.k8s.io */
final case class ServiceReference(
  name : Option[String] = None,
  namespace : Option[String] = None,
  port : Option[Int] = None
) {
  def withName(value: String) : ServiceReference = copy(name = Some(value))
  def withNamespace(value: String) : ServiceReference = copy(namespace = Some(value))
  def withPort(value: Int) : ServiceReference = copy(port = Some(value))
}

