package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1


/** APIServiceSpec contains information for locating and communicating with a server. Only https is supported, though you are able to disable certificate verification. */
final case class APIServiceSpec(
  caBundle : Option[String] = None,
  versionPriority : Int,
  service : Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference] = None,
  version : Option[String] = None,
  groupPriorityMinimum : Int,
  group : Option[String] = None,
  insecureSkipTLSVerify : Option[Boolean] = None
) {
  def withCaBundle(value: String) : APIServiceSpec = copy(caBundle = Some(value))
  def withVersionPriority(value: Int) : APIServiceSpec = copy(versionPriority = value)
  def withService(value: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference) : APIServiceSpec = copy(service = Some(value))
  def withVersion(value: String) : APIServiceSpec = copy(version = Some(value))
  def withGroupPriorityMinimum(value: Int) : APIServiceSpec = copy(groupPriorityMinimum = value)
  def withGroup(value: String) : APIServiceSpec = copy(group = Some(value))
  def withInsecureSkipTLSVerify(value: Boolean) : APIServiceSpec = copy(insecureSkipTLSVerify = Some(value))
}

