package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1


/** APIServiceCondition describes the state of an APIService at a particular point */
final case class APIServiceCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : APIServiceCondition = copy(reason = Some(value))
  def withStatus(value: String) : APIServiceCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : APIServiceCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : APIServiceCondition = copy(message = Some(value))
  def withType(value: String) : APIServiceCondition = copy(`type` = value)
}

