package io.k8s.apimachinery.pkg.version


/** Info contains versioning information. how we'll want to distribute that information. */
final case class Info(
  gitCommit : String,
  goVersion : String,
  compiler : String,
  gitVersion : String,
  gitTreeState : String,
  platform : String,
  buildDate : String,
  major : String,
  minor : String
) {
  def withGitCommit(value: String) : Info = copy(gitCommit = value)
  def withGoVersion(value: String) : Info = copy(goVersion = value)
  def withCompiler(value: String) : Info = copy(compiler = value)
  def withGitVersion(value: String) : Info = copy(gitVersion = value)
  def withGitTreeState(value: String) : Info = copy(gitTreeState = value)
  def withPlatform(value: String) : Info = copy(platform = value)
  def withBuildDate(value: String) : Info = copy(buildDate = value)
  def withMajor(value: String) : Info = copy(major = value)
  def withMinor(value: String) : Info = copy(minor = value)
}

