package io.k8s.apimachinery.pkg.apis.meta.v1


/** StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined. */
final case class StatusDetails(
  name : Option[String] = None,
  causes : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause]] = None,
  uid : Option[String] = None,
  retryAfterSeconds : Option[Int] = None,
  group : Option[String] = None
) {
  def withName(value: String) : StatusDetails = copy(name = Some(value))
  def withCauses(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause]) : StatusDetails = copy(causes = Some(value))
  def addCauses(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause*) : StatusDetails = copy(causes = Some(causes.fold(newValues)(_ ++ newValues)))

  def withUid(value: String) : StatusDetails = copy(uid = Some(value))
  def withRetryAfterSeconds(value: Int) : StatusDetails = copy(retryAfterSeconds = Some(value))
  def withGroup(value: String) : StatusDetails = copy(group = Some(value))
}

