package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._

/** Status is a return value for calls that don't return other objects. */
final case class Status(
  reason : Option[String] = None,
  code : Option[Int] = None,
  status : Option[String] = None,
  details : Option[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None,
  message : Option[String] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Status", "v1")

  def withReason(value: String) : Status = copy(reason = Some(value))
  def withCode(value: Int) : Status = copy(code = Some(value))
  def withStatus(value: String) : Status = copy(status = Some(value))
  def withDetails(value: io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails) : Status = copy(details = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : Status = copy(metadata = Some(value))
  def withMessage(value: String) : Status = copy(message = Some(value))
}

