package io.k8s.apimachinery.pkg.apis.meta.v1


/** ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match. */
final case class ServerAddressByClientCIDR(
  clientCIDR : String,
  serverAddress : String
) {
  def withClientCIDR(value: String) : ServerAddressByClientCIDR = copy(clientCIDR = value)
  def withServerAddress(value: String) : ServerAddressByClientCIDR = copy(serverAddress = value)
}

