package io.k8s.apimachinery.pkg.apis.meta.v1


/** Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out. */
final case class Preconditions(
  resourceVersion : Option[String] = None,
  uid : Option[String] = None
) {
  def withResourceVersion(value: String) : Preconditions = copy(resourceVersion = Some(value))
  def withUid(value: String) : Preconditions = copy(uid = Some(value))
}

