package io.k8s.apimachinery.pkg.apis.meta.v1


/** ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}. */
final case class ListMeta(
  continue : Option[String] = None,
  remainingItemCount : Option[Int] = None,
  resourceVersion : Option[String] = None,
  selfLink : Option[String] = None
) {
  def withContinue(value: String) : ListMeta = copy(continue = Some(value))
  def withRemainingItemCount(value: Int) : ListMeta = copy(remainingItemCount = Some(value))
  def withResourceVersion(value: String) : ListMeta = copy(resourceVersion = Some(value))
  def withSelfLink(value: String) : ListMeta = copy(selfLink = Some(value))
}

