package io.k8s.apimachinery.pkg.apis.meta.v1


/** A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values. */
final case class LabelSelectorRequirement(
  key : String,
  operator : String,
  values : Option[Seq[String]] = None
) {
  def withKey(value: String) : LabelSelectorRequirement = copy(key = value)
  def withOperator(value: String) : LabelSelectorRequirement = copy(operator = value)
  def withValues(value: Seq[String]) : LabelSelectorRequirement = copy(values = Some(value))
  def addValues(newValues: String*) : LabelSelectorRequirement = copy(values = Some(values.fold(newValues)(_ ++ newValues)))

}

