package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._

/** APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced. */
final case class APIResourceList(
  groupVersion : String,
  resources : Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource]
) extends KObject {
  protected val _resourceKind = ResourceKind("", "APIResourceList", "v1")

  def withGroupVersion(value: String) : APIResourceList = copy(groupVersion = value)
  def withResources(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource]) : APIResourceList = copy(resources = value)
  def addResources(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.APIResource*) : APIResourceList = copy(resources = resources ++ newValues)

}

