package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** WebhookConversion describes how to call a conversion webhook */
final case class WebhookConversion(
  clientConfig : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig] = None,
  conversionReviewVersions : Seq[String]
) {
  def withClientConfig(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig) : WebhookConversion = copy(clientConfig = Some(value))
  def withConversionReviewVersions(value: Seq[String]) : WebhookConversion = copy(conversionReviewVersions = value)
  def addConversionReviewVersions(newValues: String*) : WebhookConversion = copy(conversionReviewVersions = conversionReviewVersions ++ newValues)

}

