package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources. */
final case class CustomResourceSubresourceScale(
  labelSelectorPath : Option[String] = None,
  specReplicasPath : String,
  statusReplicasPath : String
) {
  def withLabelSelectorPath(value: String) : CustomResourceSubresourceScale = copy(labelSelectorPath = Some(value))
  def withSpecReplicasPath(value: String) : CustomResourceSubresourceScale = copy(specReplicasPath = value)
  def withStatusReplicasPath(value: String) : CustomResourceSubresourceScale = copy(statusReplicasPath = value)
}

