package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition */
final case class CustomResourceDefinitionNames(
  plural : String,
  singular : Option[String] = None,
  listKind : Option[String] = None,
  categories : Option[Seq[String]] = None,
  shortNames : Option[Seq[String]] = None
) {
  def withPlural(value: String) : CustomResourceDefinitionNames = copy(plural = value)
  def withSingular(value: String) : CustomResourceDefinitionNames = copy(singular = Some(value))
  def withListKind(value: String) : CustomResourceDefinitionNames = copy(listKind = Some(value))
  def withCategories(value: Seq[String]) : CustomResourceDefinitionNames = copy(categories = Some(value))
  def addCategories(newValues: String*) : CustomResourceDefinitionNames = copy(categories = Some(categories.fold(newValues)(_ ++ newValues)))

  def withShortNames(value: Seq[String]) : CustomResourceDefinitionNames = copy(shortNames = Some(value))
  def addShortNames(newValues: String*) : CustomResourceDefinitionNames = copy(shortNames = Some(shortNames.fold(newValues)(_ ++ newValues)))

}

