package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s._

/** CustomResourceDefinitionList is a list of CustomResourceDefinition objects. */
final case class CustomResourceDefinitionList(
  items : Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiextensions.k8s.io", "CustomResourceDefinitionList", "v1")

  def withItems(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition]) : CustomResourceDefinitionList = copy(items = value)
  def addItems(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition*) : CustomResourceDefinitionList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CustomResourceDefinitionList = copy(metadata = Some(value))
}

