package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceConversion describes how to convert different versions of a CR. */
final case class CustomResourceConversion(
  strategy : String,
  webhook : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion] = None
) {
  def withStrategy(value: String) : CustomResourceConversion = copy(strategy = value)
  def withWebhook(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion) : CustomResourceConversion = copy(webhook = Some(value))
}

