package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceColumnDefinition specifies a column for server side printing. */
final case class CustomResourceColumnDefinition(
  format : Option[String] = None,
  name : String,
  priority : Option[Int] = None,
  description : Option[String] = None,
  jsonPath : String,
  `type` : String
) {
  def withFormat(value: String) : CustomResourceColumnDefinition = copy(format = Some(value))
  def withName(value: String) : CustomResourceColumnDefinition = copy(name = value)
  def withPriority(value: Int) : CustomResourceColumnDefinition = copy(priority = Some(value))
  def withDescription(value: String) : CustomResourceColumnDefinition = copy(description = Some(value))
  def withJsonPath(value: String) : CustomResourceColumnDefinition = copy(jsonPath = value)
  def withType(value: String) : CustomResourceColumnDefinition = copy(`type` = value)
}

