package io.k8s.api.storage.v1


/** VolumeError captures an error encountered during a volume operation. */
final case class VolumeError(
  message : Option[String] = None,
  time : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {
  def withMessage(value: String) : VolumeError = copy(message = Some(value))
  def withTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : VolumeError = copy(time = Some(value))
}

